//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

final class Counter {
    // MARK: Internal Instance Properties
    
    private(set) var value: Int
    
    // MARK: Internal Initialization
    
    init(value: Int = 0) {
        self.value = value
    }
    
    // MARK: Internal Instance Interface
    
    func add(_ delta: Int) -> Int {
        value += delta
        
        return value
    }
    
    func add(_ a: Int, _ b: Int) -> Int {
        value += a + b
        
        return value
    }
}
